@extends('layouts.app')
@section('content')


<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Add Artist</h6>
        </div>

        <div class="releases-sec-main">

            @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form class="add-releses-form" method="POST" action="{{ route('artists.store') }}" id="frmAddArtist">
                @csrf

                <div class="row">


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="artist">Name
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the name of the artist."></i>
                            </label>
                            <input type="text" name="name" class="form-control" value="{{ old('name') }}"/>
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="artist">Email
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the email of the artist."></i>
                            </label>
                            <input type="email" name="email" class="form-control" value="{{ old('email') }}"/>
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label" for="artist">Sound  Cloud
                            </label>
                            <input type="text" name="sound_cloud"  class="form-control" value="{{ old('sound_cloud') }}">
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label" for="artist">Twitter
                            </label>
                            <input type="text" name="twitter" class="form-control" value="{{ old('twitter') }}">
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label" for="artist">Facebook
                            </label>
                            <input type="text" name="facebook" class="form-control" value="{{ old('facebook') }}">
                        </div>
                    </div>



                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label" for="artist">Instagram
                            </label>
                            <input type="text" name="instagram" placeholder="Instagram" class="form-control" value="{{ old('instagram') }}">
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label" for="artist">Youtube
                            </label>

                            <input type="text" name="youtube" placeholder="Youtube" class="form-control" value="{{ old('youtube') }}">
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label" for="artist">Website
                            </label>

                            <input type="text" name="youtube" placeholder="Youtube" class="form-control" value="{{ old('youtube') }}">
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form mt-5">
                            <label class="form-label" for="description">Genre Descriptions</label>
                            <textarea class="form-control" id="description" name="description">{{ old('description') }}</textarea>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form mt-5">
                            <label class="form-label required" for="status">Genre Status
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select whether the genre is active or disabled."></i>
                            </label>
                            <select name="status" id="status" class="form-control">
                                <option @if(old('status')==1) selected @endif value="1">Active</option>
                                <option @if(old('status')==0) selected @endif value="0">Disabled</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddArtist").validate({
            rules: {
                name: {
                    required: true
                },
                email: {
                    required: true
                },
                status: {
                    required: true
                },
            },
            messages: {
                name: {
                    required: "Artist Name field is required"
                },
                email: {
                    required: "Artist email field is required"
                },
                status: {
                    required: "Artist status field is required"
                },
            }
        });
    });
</script>

















{{--
    
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Create New Artist</h2>
        </div>
        <div class="pull-right">
            <a class="btn btn-primary btn-sm mb-2" href="{{ route('artists.index') }}"><i class="fa fa-arrow-left"></i> Back</a>
        </div>
    </div>
</div>

@if (count($errors) > 0)
    <div class="alert alert-danger">
      <strong>Whoops!</strong> There were some problems with your input.<br><br>
      <ul>
         @foreach ($errors->all() as $error)
           <li>{{ $error }}</li>
         @endforeach
      </ul>
    </div>
@endif

<form method="POST" action="{{ route('artists.store') }}">
    @csrf
    <div class="row">

        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong class="required">Name:</strong>
                <input type="text" name="name" placeholder="Name" class="form-control" required value="{{ old('name') }}"/>
            </div>
        </div>

        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong class="required">Email:</strong>
                <input type="email" name="email" placeholder="Email" class="form-control" required value="{{ old('email') }}" />
            </div>
        </div>

        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Sound Cloud:</strong>
                <input type="text" name="sound_cloud" placeholder="Sound Cloud" class="form-control" value="{{ old('sound_cloud') }}">
            </div>
        </div>


        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Twitter:</strong>
                <input type="text" name="twitter" placeholder="Twitter" class="form-control" value="{{ old('twitter') }}">
            </div>
        </div>

        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Facebook:</strong>
                <input type="text" name="facebook" placeholder="Facebook" class="form-control" value="{{ old('facebook') }}">
            </div>
        </div>


        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Instagram:</strong>
                <input type="text" name="instagram" placeholder="Instagram" class="form-control" value="{{ old('instagram') }}">
            </div>
        </div>


        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Youtube:</strong>
                <input type="text" name="youtube" placeholder="Youtube" class="form-control" value="{{ old('youtube') }}">
            </div>
        </div>



        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Brand Camp:</strong>
                <input type="text" name="brandcamp" placeholder="Brand Camp" class="form-control" value="{{ old('brandcamp') }}">
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Website:</strong>
                <input type="text" name="website" placeholder="Website" class="form-control" value="{{ old('website') }}">
            </div>
        </div>

        

        <h3 class="p-3">Spotify Artist Page</h3>
        <strong>Is this artist on spotify already?:</strong>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
            <input type="radio" checked name="is_on_spotfy"  class="form-check-input" value="1">
                <label>Yes, I can provide a link:</label>
                
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
            <input type="radio"  name="is_on_spotfy"  class="form-check-input" value="0">
                <label>No, I need an artist page created,(We will request a new artist page be created for you. You must update the page info here once live):</label>
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12 mt-3"  id="spotifyArtistData">
            <div class="form-group">
                <strong>Spotify Artist Link:</strong>
                <input type="text" name="spotfy_link" placeholder="Spotfy Link" class="form-control" value="{{ old('spotfy_link') }}">
            </div>
        </div>


        <h3 class="p-3">Apple Artist Page</h3>
        <strong>Is this artist on Apple already?:</strong>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
            <input type="radio" checked name="is_on_apple"  class="form-check-input" value="1">
                <label>Yes, I can provide a link:</label>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
            <input type="radio"  name="is_on_apple"  class="form-check-input" value="0">
                <label>No, I need an artist page created,(We will request a new artist page be created for you. You must update the page info here once live):</label>
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12 mt-3"  id="appleArtistData">
            <div class="form-group">
                <strong>Apple Artist Link:</strong>
                <input type="text" name="apple_link" placeholder="Apple Link" class="form-control" value="{{ old('apple_link') }}">
            </div>
        </div>


        <div class="col-xs-6 col-sm-6 col-md-6">
            <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk"></i> Submit</button>
        </div>

    </div>
</form>

<script>
$('input[type=radio][name=is_on_spotfy]').on('change', function() {
    if($(this).val() == 1){
        $('#spotifyArtistData').show();
    }else{
        $('#spotifyArtistData').hide();
    }
});

$('input[type=radio][name=is_on_apple]').on('change', function() {
    if($(this).val() == 1){
        $('#appleArtistData').show();
    }else{
        $('#appleArtistData').hide();
    }
});

</script>
--}}


@endsection
